using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PI.ZB.N1200.ELearning.WinForms.CompetencePart
{                                        
    public partial class FNewCompetencePart : PI.FM.N000.Base.WinForms.Controls.Form
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.ZB.N1200.ELearning.BL.BO.CompetencePart _newCompetencePart = null;

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning ZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(this.Environment);
                }
                return _blZSBELearning;
            }
        }

        public FNewCompetencePart()
        {
            InitializeComponent();
        }

        public PI.ZB.N1200.ELearning.BL.BO.CompetencePart NewCompetencePart
        {
            get 
            {
                if (_newCompetencePart == null)
                {
                    if ((!String.IsNullOrEmpty(_gTextBoxName.Text)) && (_gComboBoxCompetence.GetSelectedObjectValue() != null))
                    {
                        _newCompetencePart = ZSBELearning.CompetencePart.New(_gTextBoxName.Text.Trim(), (BL.BO.Competence)_gComboBoxCompetence.GetSelectedObjectValue());
                    }
                }

                return _newCompetencePart; 
            }
        }

        public void Initialize(BL.BO.Competence Competence,Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment Environment)
        {
            Initialize(ParentPlugIn, Environment);

            if (Competence != null)
            {
                _gComboBoxCompetence.SetSelectedID<BL.BO.Competence>(Competence.ID);
                SetRowHidden(_tableLayoutPanel, _gComboBoxCompetence);
            }
        }

        public new void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment Environment)
        {
            base.Initialize(ParentPlugIn, Environment);

            _gComboBoxCompetence.SetDataSource(ZSBELearning.Competence.Restore(), new string[] { "ID","Name"});
        }

        private void ButtonOK_Click(object sender, EventArgs e)
        {
            bool _isValid = true;
            List<string> _listMessage = new List<string>();

            _gTextBoxName.ErrorText = null;
            _gComboBoxCompetence.ErrorText = null;

            if(String.IsNullOrEmpty(_gTextBoxName.Text))
            {
                _gTextBoxName.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelName.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelName.PlainText));
                _isValid = false;
            }

            if (_gComboBoxCompetence.GetSelectedObjectValue() == null)
            {
                _gComboBoxCompetence.ErrorText = String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelCompetence.PlainText);
                _listMessage.Add(String.Format(Gemini.Dictionary.Text.WarningValueIsMandatory.Value, _gLabelCompetence.PlainText));
                _isValid = false;
            }


            if (_isValid)
            {
                DialogResult = DialogResult.OK;
                Close();
            }
            else
            {
                DialogResult = DialogResult.None;
                PI.FM.N000.Base.WinForms.Controls.FDefaultMessage _dialog = new PI.FM.N000.Base.WinForms.Controls.FDefaultMessage();
                _dialog.SetMessage = _listMessage;
                _dialog.ShowDialog();
            }
        }

        private void ButtonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}